<?php


spl_autoload_register(function ($classname)  {

    if (in_array($classname, get_declared_classes())) {
        return;
    }

    $wpPath = realpath(get_template_directory()) . DIRECTORY_SEPARATOR . $classname . '.php';

    if (includeClass($wpPath)) {
        return;
    }

});

function includeClass(string $path): bool
{
    $wpPath = str_replace('\\', '/', $path);
    if (file_exists($wpPath)) {
        include_once $wpPath;
        return true;
    }
    return false;
}



