<?php

namespace m360sync;

class ApiFunc
{
    const API = 'https://storefront-api.marketer-services.dev/api/v1/';
    const API_TOKEN = 'https://auth.marketer-services.dev/oauth/token';

    static function instance()
    {
        return new static;
    }
    function getToken(){
        $curl = curl_init();
        $headers = [
            'Content-Type: application/json',
        ];
        $clientId = get_option('m360-sync-client-id');
        $clientSecret = get_option('m360-sync-client-secret');

        $params = ["client_id" => "$clientId", "client_secret" => "$clientSecret", "scope" => "storefrontapi:projects_with_resources", "grant_type" => "client_credentials"];
        curl_setopt_array($curl, [
            CURLOPT_URL        => self::API_TOKEN,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => wp_json_encode($params),
            CURLOPT_RETURNTRANSFER => 1,
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response);
    }
    function getProjectWithResources($uuid)
    {
        if (!$uuid) {
            return false;
        }
        $accessToken = $this->getToken()->access_token;
        $curl = curl_init();
        $headers = [
            'authorization: Bearer ' . $accessToken,
            'Content-Type: application/json',
        ];
        curl_setopt_array($curl, [
            CURLOPT_URL        => self::API . 'projects_with_resources/' . $uuid,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST  => 'GET',
            CURLOPT_RETURNTRANSFER => 1,
        ]);
        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($httpCode !== 200) {
            return null;
        }
        curl_close($curl);
        return json_decode($response);
    }
    function getAllProjects()
    {
        $accessToken = $this->getToken()->access_token;
        $curl = curl_init();
        $headers = [
            'authorization: Bearer ' . $accessToken,
            'Content-Type: application/json',
        ];
        curl_setopt_array($curl, [
            CURLOPT_URL        => self::API . 'projects_with_resources/',
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST  => 'GET',
            CURLOPT_RETURNTRANSFER => 1,
        ]);
        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($httpCode !== 200) {
            return null;
        }
        curl_close($curl);
        return json_decode($response);
    }
}
?>